//								EJEMPLO 12
//						Autor: Mikel Etxebarria
//			(c) Ingeniera de Microsistemas Programados S.L.
//						www.microcontroladores.com
//								Bilbao 2006
//
//El Display de 7 segmentos. Decodificador hex. BCD a 7 segmentos.
//
//Mediante los cuatro interruptores RA0-RA3 se introduce un valor hexadecimal de 4 bits
//que debe visualizarse sobre el display.

#include <16f876A.h>

//Ajusta los valores de la palabra de configuracin durante el ensamblaje:
//Proteccin de cdigo y datos=OFF, LVP=OFF, WDT=OFF y OSC=XT

#fuses NOPROTECT,NOCPD,NOLVP,NOWDT,XT

// Con estas directivas las funciones "input" y "output_bit" no reprograman
// el pin de la puerta cada vez que son utilizadas. Si no se indica el
// modo fast_io se asume por defecto standard_io el cual reprograma el pin
// siempre antes de ser utilizadas estas funciones.

#use fast_io (A)
#use fast_io (B)

main()
{  
	unsigned int const display[16]={0x3F,0x06,0x5B,0x4F,// Al ser una tabla constante
                               0x66,0x6D,0x7D,0x07,		// se crea dentro de la memoria
                               0x7F,0x6F,0x77,0x7C,		// de programa.
                               0x39,0x5E,0x79,0x71};

	SETUP_ADC_PORTS(NO_ANALOGS);	//Puerta A Digital
	set_tris_a(0x3F);				//RA0-RA5 entradas
	set_tris_b(0x00);				//RB0-RB7 salidas	   
	output_b (0x00);				//Borra las salidas


	while(1)

	output_b(display[input_a() & 0x0f]);	//Lee el valor de la puerta A y visualiza	 
}	



